#!/bin/bash
#-----------用户修改------------
#请用户修改下方id，字数至少大于8位，防止与他人重复，#
#端口port，1至65535
#说明，如果无法更新ID，请换个ID，如需删除后台，请登录http://www.ipv6t.online/，查询ID后，有删除选项
#requests，json需要安装依赖，如已安装，可忽略
id="12345abcde"
port="88"

#用户链接参考  http://www.ipv6t.online:90/id.php?id=1234512343
#-----------用户修改截止---------


# 定义URL
ipv6url="http://www.ipv6t.online:90/ipv6.php"

# 发送GET请求并获取JSON响应
response=$(curl -s "$ipv6url")
#echo $response

# 使用 jq 解析 JSON 字符串，提取 ipv6 字段
ipv6=$(echo "$response" | jq -r '.[0].ipv6')

# 检查是否成功提取到 ipv6 字段
if [ -z "$ipv6" ]; then
    echo "未能成功提取 ipv6 字段"
    exit 1
fi

# 打印提取到的 ipv6 地址
echo "IPv6: $ipv6"

# 获取本机的MAC地址
#MAC=$(ip link show | grep -oP 'ether \K[0-9a-fA-F:]{17}')#获取多个MAC
#选择第一个 MAC 地址：
MAC=$(ip link show | grep -oP 'ether \K[0-9a-fA-F:]{17}' | head -n 1)

# 检查是否成功获取到MAC地址
if [ -z "$MAC" ]; then
    echo "未能成功获取MAC地址"
    exit 1
fi
echo "MAC: $MAC"

url="http://www.ipv6t.online:90/input.php"
type="update"
sign="1"
response2=$(curl -s -X POST -d "type=$type&ipv6=$ipv6&id=$id&port=$port&sign=$sign&MAC=$MAC" $url)
#echo $response2



# 检查POST请求是否成功
if [ -z "$response" ]; then
    echo "POST请求失败"
    exit 1
fi
message=$(echo "$response2" | jq -r '.[0].response')
# 将 Unicode 编码转换为中文
chinese_message=$(echo -e "$message" | iconv -f UTF-8 -t UTF-8//IGNORE)

echo "Message: $chinese_message"












